/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.OVersionRecordConflictStrategy;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerSecurityConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import net.lingala.zip4j.ZipFile;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class Main {
    private static final String PROMPT = "=> ";
    private static final String DEFAULT_JSON_FORMAT = "rid,attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0";
    private static String jsonFormat = "rid,attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0";
    private static Terminal terminal;
    private static History history;
    private static String historyPath;
    private static String extractDir;
    private static String exportPath;
    private static String binaryField;
    private static String[] fieldNames;
    private static String paging;
    private static int pageCount;
    private static String ridName;
    private static int lastRows;
    private static String lastRid;
    private static String dbUser;
    private static String dbPwd;
    private static Boolean isServer;
    private static OServer server;
    private static final ObjectMapper objectMapper;
    private static final Gson gson;

    private static void usage() {
        System.err.println("https://github.com/hajimeo/samples/blob/master/java/orient-console/README.md");
    }

    private static String getCurrentLocalDateTimeStamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    private static void log(String msg) {
        System.err.println(Main.getCurrentLocalDateTimeStamp() + " " + msg);
    }

    private static void unzip(String zipFilePath, String destPath) throws IOException {
        Path source = new File(zipFilePath).toPath();
        File destDir = new File(destPath);
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException("Couldn't create " + destDir);
        }
        new ZipFile(source.toFile()).extractAll(destPath);
    }

    private static boolean prepareDir(String dirPath, String zipFilePath) throws IOException {
        File destDir = new File(dirPath);
        if (!destDir.exists()) {
            if (!destDir.mkdirs()) {
                Main.log("Couldn't create " + destDir);
                return false;
            }
        } else if (!Main.isDirEmpty(destDir.toPath())) {
            Main.log(dirPath + " is not empty.");
            return false;
        }
        long usable_space = Files.getFileStore(new File(dirPath).toPath()).getUsableSpace();
        long zip_file_size = new File(zipFilePath).length();
        if (zip_file_size * 10L > usable_space) {
            Main.log(dirPath + " (usable:" + usable_space + ") may not be enough for extracting " + zipFilePath + " (size:" + zip_file_size + ")");
            return false;
        }
        return true;
    }

    private static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    private static void delR(Path path) throws IOException {
        if (path == null || !path.toFile().exists()) {
            return;
        }
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
            try {
                Files.delete(p);
            }
            catch (IOException e) {
                Main.log(e.getMessage());
            }
        });
    }

    private static void printListAsJson(List<ODocument> oDocs, boolean isPaging) {
        if (oDocs == null || oDocs.isEmpty()) {
            if (!isPaging) {
                terminal.writer().println("\n[]");
            }
            terminal.flush();
            return;
        }
        if (!isPaging) {
            terminal.writer().println("\n[");
        }
        for (int i = 0; i < oDocs.size(); ++i) {
            if (!isPaging && i == oDocs.size() - 1) {
                terminal.writer().println("  " + oDocs.get(i).toJSON(jsonFormat));
            } else {
                terminal.writer().println("  " + oDocs.get(i).toJSON(jsonFormat) + ",");
            }
            terminal.flush();
        }
        if (!isPaging) {
            terminal.writer().println("]");
        }
        terminal.flush();
    }

    private static void printDocAsJson(ODocument oDoc) {
        terminal.writer().println(oDoc.toJSON("rid,attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0,prettyPrint"));
        terminal.flush();
    }

    private static void printBinary(ODocument oDoc) {
        ArrayList<String> fieldList;
        if (binaryField.isEmpty()) {
            return;
        }
        if (fieldNames.length == 0) {
            fieldNames = oDoc.fieldNames();
        }
        if ((fieldList = new ArrayList<String>(Arrays.asList(fieldNames))).contains(binaryField)) {
            System.out.println(Main.bytesToStr((ORecordBytes)oDoc.field(binaryField)));
        }
    }

    private static String bytesToStr(ORecordBytes rawBytes) {
        String str = "";
        try {
            Map<String, Object> raw = objectMapper.readValue(rawBytes.toStream(), new TypeReference<Map<String, Object>>(){});
            str = gson.toJson(raw);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeListAsJson(List<ODocument> oDocs, String exportPath, boolean isPaging) {
        System.err.println("");
        try {
            File fout = new File(exportPath);
            FileOutputStream fos = new FileOutputStream(fout, true);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            if (oDocs == null || oDocs.isEmpty()) {
                bw.close();
                return;
            }
            if (!isPaging && oDocs.size() == 1) {
                bw.write("[" + oDocs.get(0).toJSON(jsonFormat) + "]");
                bw.newLine();
                bw.close();
                return;
            }
            if (!isPaging) {
                bw.write("[\n");
            }
            for (int i = 0; i < oDocs.size(); ++i) {
                if (!isPaging && i == oDocs.size() - 1) {
                    bw.write("  " + oDocs.get(i).toJSON(jsonFormat));
                } else {
                    bw.write("  " + oDocs.get(i).toJSON(jsonFormat) + ",");
                }
                bw.newLine();
            }
            if (!isPaging) {
                bw.write("]");
            }
            if (!isPaging) {
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            System.err.println("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void execQueries(ODatabaseDocumentTx db, String input) {
        queries = Arrays.asList(input.split(";"));
        for (i = 0; i < queries.size(); ++i) {
            block11: {
                q = queries.get(i);
                if (q == null || q.isEmpty()) continue;
                start = Instant.now();
                isPaging = false;
                if (Main.paging == null || Main.paging.trim().length() <= 0 || !q.toLowerCase().startsWith("select ")) ** GOTO lbl24
                if (!q.toLowerCase().contains(" order by ") && !q.toLowerCase().contains(" limit ")) break block11;
                Main.log("\nERROR: 'paging' is given but query contains 'order by' or 'limit'.");
                finish = Instant.now();
                timeElapsed = Duration.between(start, finish).toMillis();
                System.err.printf("Elapsed: %d ms\n", new Object[]{timeElapsed});
                continue;
            }
            try {
                if (!q.toLowerCase().contains(" where ")) {
                    Main.log("\nWARN: 'paging' is given but OrientDB 2.x pagination may not work with 'where' clause ... :(");
                }
                if (!q.toLowerCase().contains(" " + Main.ridName + ",")) {
                    Main.log("\nWARN: 'paging' is given but query may not contain '@rid as " + Main.ridName + "'");
                }
                Main.log("\nINFO: pagination is enabled with paging size:" + Main.paging + "");
                isPaging = true;
lbl24:
                // 2 sources

                Main.execQuery(db, q, isPaging);
                while (isPaging && Main.lastRows > 0) {
                    Main.log("Fetching page:" + ++Main.pageCount + " with last_rid:" + Main.lastRid + " last_rows:" + Main.lastRows);
                    Main.execQuery(db, q, isPaging);
                }
            }
            catch (ClassCastException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                finish = Instant.now();
                timeElapsed = Duration.between(start, finish).toMillis();
                System.err.printf("Elapsed: %d ms\n", new Object[]{timeElapsed});
                continue;
            }
            catch (OCommandExecutionException | OCommandSQLParsingException ex) {
                Main.removeLine(input);
                Main.history.load();
                {
                    catch (Throwable var10_17) {
                        finish = Instant.now();
                        timeElapsed = Duration.between(start, finish).toMillis();
                        System.err.printf("Elapsed: %d ms\n", new Object[]{timeElapsed});
                        throw var10_17;
                    }
                }
                finish = Instant.now();
                timeElapsed = Duration.between(start, finish).toMillis();
                System.err.printf("Elapsed: %d ms\n", new Object[]{timeElapsed});
                continue;
            }
            finish = Instant.now();
            timeElapsed = Duration.between(start, finish).toMillis();
            System.err.printf("Elapsed: %d ms\n", new Object[]{timeElapsed});
            continue;
        }
    }

    private static void execQuery(ODatabaseDocumentTx db, String query, boolean isPaging) {
        Object oDocs;
        if (isPaging) {
            query = query.toLowerCase().contains(" where ") ? query.replaceAll(" (?i)where ", " WHERE @rid > " + lastRid + " AND ") : query + " WHERE @rid > " + lastRid;
            query = query + " LIMIT " + paging;
        }
        if ((oDocs = db.command(new OCommandSQL(query)).execute(new Object[0])) instanceof Integer) {
            System.err.printf("Rows: %d, ", oDocs);
        } else if (oDocs instanceof ODocument) {
            Main.printDocAsJson((ODocument)oDocs);
        } else {
            if (((List)oDocs).size() > 0) {
                fieldNames = ((ODocument)((List)oDocs).get(0)).fieldNames();
            }
            if (exportPath != null && exportPath.length() > 0) {
                Main.writeListAsJson((List)oDocs, exportPath, isPaging);
                if (!isPaging) {
                    System.err.printf("Wrote %d rows to %s.\n", ((List)oDocs).size(), exportPath);
                }
            } else {
                Main.printListAsJson((List)oDocs, isPaging);
                if (!isPaging) {
                    System.err.printf("Rows: %d, ", ((List)oDocs).size());
                }
            }
            if (((List)oDocs).size() == 1) {
                Main.printBinary((ODocument)((List)oDocs).get(0));
            }
            lastRows = ((List)oDocs).size();
            if (isPaging && lastRows > 0) {
                lastRid = ((ODocument)((ODocument)((List)oDocs).get(lastRows - 1)).field(ridName)).getIdentity().toString();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeLine(String inputToRemove) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String currentLine;
            File inputFile = new File(historyPath);
            File tempFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
            reader = new BufferedReader(new FileReader(inputFile));
            writer = new BufferedWriter(new FileWriter(tempFile));
            while ((currentLine = reader.readLine()) != null) {
                block17: {
                    try {
                        if (currentLine.matches("^[0-9]+:" + inputToRemove + "$")) {
                        }
                        break block17;
                    }
                    catch (IllegalArgumentException ee) {
                        Main.log(ee.getMessage());
                    }
                    continue;
                }
                writer.write(currentLine + System.getProperty("line.separator"));
            }
            tempFile.renameTo(inputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void readLineLoop(ODatabaseDocumentTx db, LineReader reader) {
        String input = reader.readLine(PROMPT);
        while (input != null && !input.startsWith("exit")) {
            try {
                boolean executingQuery = true;
                if (input.startsWith("--")) {
                    executingQuery = false;
                } else if (input.toLowerCase().startsWith("set pretty true")) {
                    jsonFormat = "rid,attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0,prettyPrint";
                    executingQuery = false;
                } else if (input.toLowerCase().startsWith("set pretty false")) {
                    jsonFormat = DEFAULT_JSON_FORMAT;
                    executingQuery = false;
                }
                if (executingQuery && db != null) {
                    Main.execQueries(db, input);
                }
                input = reader.readLine(PROMPT);
            }
            catch (UserInterruptException e) {
                System.err.println("^C");
                input = "";
            }
            catch (EndOfFileException e) {
                System.err.println("^D");
                return;
            }
        }
    }

    private static Set<String> genAutoCompWords(String fileName) {
        HashSet<String> wordSet = new HashSet<String>(Arrays.asList("CREATE", "SELECT FROM", "UPDATE", "INSERT INTO", "DELETE FROM", "FROM", "WHERE", "BETWEEN", "AND", "DISTINCT", "DISTINCT", "LIKE", "LIMIT", "NOT"));
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));){
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, " ,.;:\"");
                while (st.hasMoreTokens()) {
                    String w = st.nextToken();
                    if (!w.matches("^[a-zA-Z]*$")) continue;
                    wordSet.add(w);
                }
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return wordSet;
    }

    private static LineReader setupReader() throws IOException {
        terminal = TerminalBuilder.builder().system(true).dumb(true).build();
        history = new DefaultHistory();
        historyPath = System.getProperty("user.home") + "/.orient-console_history";
        System.err.println("history path: " + historyPath);
        Set<String> words = Main.genAutoCompWords(historyPath);
        LineReader lr = LineReaderBuilder.builder().terminal(terminal).highlighter(new DefaultHighlighter()).history(history).completer(new StringsCompleter(words)).variable("history-file", new File(historyPath)).build();
        history.attach(lr);
        return lr;
    }

    private static void startServer(String dbPath) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, ClassNotFoundException, MBeanRegistrationException, IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        File databaseDir = new File(dbPath).getCanonicalFile().getParentFile();
        Path homeDir = databaseDir.toPath();
        System.setProperty("orient.home", homeDir.toString());
        System.setProperty("ORIENTDB_HOME", homeDir.toString());
        server = new OServer();
        OServerConfiguration config = new OServerConfiguration();
        config.location = "DYNAMIC-CONFIGURATION";
        File securityFile = new File(databaseDir, "orient-console-security.json");
        config.properties = new OServerEntryConfiguration[]{new OServerEntryConfiguration("server.database.path", databaseDir.getPath()), new OServerEntryConfiguration("server.security.file", securityFile.getPath())};
        config.handlers = Lists.newArrayList();
        config.hooks = Lists.newArrayList();
        config.network = new OServerNetworkConfiguration();
        config.network.protocols = Lists.newArrayList(new OServerNetworkProtocolConfiguration("binary", ONetworkProtocolBinary.class.getName()));
        OServerNetworkListenerConfiguration binaryListener = new OServerNetworkListenerConfiguration();
        binaryListener.ipAddress = "0.0.0.0";
        binaryListener.portRange = "2424-2430";
        binaryListener.protocol = "binary";
        binaryListener.socket = "default";
        config.network.listeners = Lists.newArrayList(binaryListener);
        config.storages = new OServerStorageConfiguration[0];
        config.users = new OServerUserConfiguration[]{new OServerUserConfiguration(dbUser, dbPwd, "*")};
        config.security = new OServerSecurityConfiguration();
        config.security.users = Lists.newArrayList();
        config.security.resources = Lists.newArrayList();
        server.startup(config);
        server.addUser("root", "SomeRootPassword", "*");
        server.activate();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OGlobalConfiguration.dumpConfiguration(new PrintStream(baos, true));
        Main.log("Global configuration:\n" + baos.toString("UTF8"));
    }

    private Main() {
    }

    private static void setGlobals() {
        String envOrientDBPwd;
        extractDir = System.getProperty("extractDir", System.getenv("_EXTRACT_DIR"));
        exportPath = System.getProperty("exportPath", System.getenv("_EXPORT_PATH"));
        binaryField = System.getProperty("binaryField", "");
        paging = System.getProperty("paging", "");
        ridName = System.getProperty("ridName", "rid");
        lastRid = System.getProperty("lastRid", "#-1:-1");
        String envOrientDBUser = System.getenv("ORIENTDB_USER");
        if (envOrientDBUser != null) {
            dbUser = envOrientDBUser;
        }
        if ((envOrientDBPwd = System.getenv("ORIENTDB_PWD")) != null) {
            dbPwd = envOrientDBPwd;
        }
        isServer = Boolean.getBoolean("server");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            Main.usage();
            System.exit(1);
        }
        Main.setGlobals();
        String path = args[0];
        Path tmpDir = null;
        if (exportPath != null && exportPath.length() > 0) {
            File yourFile = new File(exportPath);
            yourFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(yourFile, false);
            fos.close();
        }
        if (!(path.startsWith("remote:") || new File(path).isDirectory() || new File(path).isDirectory())) {
            try {
                if (extractDir != null && !extractDir.trim().isEmpty()) {
                    if (!Main.prepareDir(extractDir, path)) {
                        System.exit(1);
                    }
                } else {
                    tmpDir = Files.createTempDirectory(null, new FileAttribute[0]);
                    tmpDir.toFile().deleteOnExit();
                    extractDir = tmpDir.toString();
                }
                Main.log("Unzip-ing " + path + " to " + extractDir);
                Main.unzip(path, extractDir);
                path = extractDir;
            }
            catch (Exception e) {
                Main.log(path + " is not a right archive.");
                e.printStackTrace();
                Main.delR(tmpDir);
                System.exit(1);
            }
        }
        String dbName = new File(path).getName();
        try {
            ODatabaseDocumentTx db = null;
            if (isServer != null && isServer.booleanValue()) {
                Main.startServer(path);
                System.err.println("# Service started for " + path);
                path = "remote:127.0.0.1/" + dbName;
            }
            if (path.startsWith("remote:")) {
                System.err.println("# connecting to " + path);
                db = new ODatabaseDocumentTx(path);
                db.setProperty("connectionStrategy", OStorageRemote.CONNECTION_STRATEGY.STICKY.toString());
            } else {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                System.err.println("# connecting to plocal:" + path);
                db = new ODatabaseDocumentTx("plocal:" + path);
            }
            Orient.instance().getRecordConflictStrategy().registerImplementation("ConflictHook", new OVersionRecordConflictStrategy());
            try {
                db.open(dbUser, dbPwd);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            System.err.println("# Type 'exit' or Ctrl+D to exit. Ctrl+C to cancel current query");
            Main.readLineLoop(db, Main.setupReader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (server != null) {
            server.shutdown();
        }
        Main.delR(tmpDir);
        System.err.println("");
    }

    static {
        paging = "";
        pageCount = 1;
        ridName = "rid";
        lastRows = 0;
        lastRid = "#-1:-1";
        dbUser = "admin";
        dbPwd = "admin";
        objectMapper = new ObjectMapper(new SmileFactory());
        gson = new Gson();
    }
}

