/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.concur.lock.OAbstractLock;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OAdaptiveLock
extends OAbstractLock {
    private final ReentrantLock lock = new ReentrantLock();
    private final boolean concurrent;
    private final int timeout;
    private final boolean ignoreThreadInterruption;

    public OAdaptiveLock() {
        this.concurrent = true;
        this.timeout = 0;
        this.ignoreThreadInterruption = false;
    }

    public OAdaptiveLock(int iTimeout) {
        this.concurrent = true;
        this.timeout = iTimeout;
        this.ignoreThreadInterruption = false;
    }

    public OAdaptiveLock(boolean iConcurrent) {
        this.concurrent = iConcurrent;
        this.timeout = 0;
        this.ignoreThreadInterruption = false;
    }

    public OAdaptiveLock(boolean iConcurrent, int iTimeout, boolean ignoreThreadInterruption) {
        this.concurrent = iConcurrent;
        this.timeout = iTimeout;
        this.ignoreThreadInterruption = ignoreThreadInterruption;
    }

    @Override
    public void lock() {
        if (this.concurrent) {
            if (this.timeout > 0) {
                try {
                    if (this.lock.tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    if (this.ignoreThreadInterruption) {
                        try {
                            if (this.lock.tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        catch (InterruptedException ignore) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    throw OException.wrapException(new OLockException("Thread interrupted while waiting for resource of class '" + this.getClass() + "' with timeout=" + this.timeout), e);
                }
                this.throwTimeoutException(this.lock);
            } else {
                this.lock.lock();
            }
        }
    }

    public boolean tryAcquireLock() {
        return this.tryAcquireLock(this.timeout, TimeUnit.MILLISECONDS);
    }

    public boolean tryAcquireLock(long iTimeout, TimeUnit iUnit) {
        if (this.concurrent) {
            if (this.timeout > 0) {
                try {
                    return this.lock.tryLock(iTimeout, iUnit);
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OLockException("Thread interrupted while waiting for resource of class '" + this.getClass() + "' with timeout=" + this.timeout), e);
                }
            }
            return this.lock.tryLock();
        }
        return true;
    }

    @Override
    public void unlock() {
        if (this.concurrent) {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Cannot unlock a lock", e, new Object[0]);
        }
    }

    private void throwTimeoutException(Lock lock) {
        String owner = this.extractLockOwnerStackTrace(lock);
        throw new OTimeoutException("Timeout on acquiring exclusive lock against resource of class: " + this.getClass() + " with timeout=" + this.timeout + (owner != null ? "\n" + owner : ""));
    }

    private String extractLockOwnerStackTrace(Lock lock) {
        try {
            StackTraceElement[] stackTrace;
            Field syncField = lock.getClass().getDeclaredField("sync");
            syncField.setAccessible(true);
            Object sync = syncField.get(lock);
            Method getOwner = sync.getClass().getSuperclass().getDeclaredMethod("getOwner", new Class[0]);
            getOwner.setAccessible(true);
            Thread owner = (Thread)getOwner.invoke(sync, new Object[0]);
            if (owner == null) {
                return null;
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.append("Owner thread : ").append(owner.toString()).append("\n");
            for (StackTraceElement traceElement : stackTrace = owner.getStackTrace()) {
                printWriter.println("\tat " + traceElement);
            }
            printWriter.flush();
            return stringWriter.toString();
        }
        catch (RuntimeException ignore) {
            return null;
        }
        catch (NoSuchFieldException ignore) {
            return null;
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
        catch (InvocationTargetException ignore) {
            return null;
        }
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public ReentrantLock getUnderlying() {
        return this.lock;
    }

    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }
}

