/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class OSQLDumper {
    private static final String COMMAND_START = "<command>";
    private static final String COMMAND_END = "</command>";
    private static final String QUERY_START = "<query>";
    private static final String QUERY_END = "</query>";

    public static Collection<String> dumpAllSQLQueries() {
        ArrayList<String> runningQueries = new ArrayList<String>();
        try {
            Set<Thread> threads = Thread.getAllStackTraces().keySet();
            for (Thread thread : threads) {
                String name = thread.getName();
                if (name == null) continue;
                int queryStart = name.indexOf(QUERY_START);
                if (queryStart == -1) {
                    int commandEnd;
                    int commandStart = name.indexOf(COMMAND_START);
                    if (commandStart == -1 || (commandEnd = name.indexOf(COMMAND_END)) == -1) continue;
                    String command = name.substring(commandStart + COMMAND_START.length(), commandEnd);
                    runningQueries.add(command);
                    continue;
                }
                int queryEnd = name.indexOf(QUERY_END);
                if (queryEnd == -1) continue;
                String query = name.substring(queryStart + QUERY_START.length(), queryEnd);
                runningQueries.add(query);
            }
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
        return runningQueries;
    }
}

