/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.enterprise.channel.OSocketFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.OResponseProcessingException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;

public abstract class OChannelBinaryClientAbstract
extends OChannelBinary {
    protected final int socketTimeout;
    protected final short srvProtocolVersion;
    protected String serverURL;
    protected byte currentStatus;
    protected int currentSessionId;

    public OChannelBinaryClientAbstract(String remoteHost, int remotePort, String iDatabaseName, OContextConfiguration iConfig, int protocolVersion) throws IOException {
        super(OSocketFactory.instance(iConfig).createSocket(), iConfig);
        try {
            this.serverURL = remoteHost + ":" + remotePort;
            if (iDatabaseName != null) {
                this.serverURL = this.serverURL + "/" + iDatabaseName;
            }
            this.socketTimeout = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
            try {
                if (remoteHost.contains(":")) {
                    InetAddress[] addresses = Inet6Address.getAllByName(remoteHost);
                    this.socket.connect(new InetSocketAddress(addresses[0], remotePort), this.socketTimeout);
                } else {
                    this.socket.connect(new InetSocketAddress(remoteHost, remotePort), this.socketTimeout);
                }
                this.setReadResponseTimeout();
                this.connected();
            }
            catch (SocketTimeoutException e) {
                throw new IOException("Cannot connect to host " + remoteHost + ":" + remotePort + " (timeout=" + this.socketTimeout + ")", e);
            }
            try {
                if (this.socketBufferSize > 0) {
                    this.inStream = new BufferedInputStream(this.socket.getInputStream(), this.socketBufferSize);
                    this.outStream = new BufferedOutputStream(this.socket.getOutputStream(), this.socketBufferSize);
                } else {
                    this.inStream = new BufferedInputStream(this.socket.getInputStream());
                    this.outStream = new BufferedOutputStream(this.socket.getOutputStream());
                }
                this.in = new DataInputStream(this.inStream);
                this.out = new DataOutputStream(this.outStream);
                this.srvProtocolVersion = this.readShort();
            }
            catch (IOException e) {
                throw new ONetworkProtocolException("Cannot read protocol version from remote server " + this.socket.getRemoteSocketAddress() + ": " + e);
            }
            if (this.srvProtocolVersion != protocolVersion) {
                OLogManager.instance().warn((Object)this, "The Client driver version is different than Server version: client=" + protocolVersion + ", server=" + this.srvProtocolVersion + ". You could not use the full features of the newer version. Assure to have the same versions on both", new Object[0]);
            }
        }
        catch (RuntimeException e) {
            if (this.socket.isConnected()) {
                this.socket.close();
            }
            throw e;
        }
    }

    private static RuntimeException createException(String iClassName, String iMessage, Exception iPrevious) {
        OException rootException = null;
        Constructor<?> c = null;
        try {
            Class<?> excClass = Class.forName(iClassName);
            if (iPrevious != null) {
                try {
                    c = excClass.getConstructor(String.class, Throwable.class);
                }
                catch (NoSuchMethodException e) {
                    c = excClass.getConstructor(String.class, Exception.class);
                }
            }
            if (c == null) {
                c = excClass.getConstructor(String.class);
            }
        }
        catch (Exception e) {
            rootException = OException.wrapException(new OSystemException(iMessage), iPrevious);
        }
        if (c != null) {
            try {
                Exception cause = c.getParameterTypes().length > 1 ? (Exception)c.newInstance(iMessage, iPrevious) : (Exception)c.newInstance(iMessage);
                rootException = OException.wrapException(new OSystemException("Data processing exception"), cause);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return rootException;
    }

    @Override
    public void clearInput() throws IOException {
        this.acquireReadLock();
        try {
            super.clearInput();
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isConnected() {
        Socket s2 = this.socket;
        return s2 != null && !s2.isClosed() && s2.isConnected() && !s2.isInputShutdown() && !s2.isOutputShutdown();
    }

    public short getSrvProtocolVersion() {
        return this.srvProtocolVersion;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public boolean tryLock() {
        return this.getLockWrite().tryAcquireLock();
    }

    public void unlock() {
        this.getLockWrite().unlock();
    }

    protected int handleStatus(byte iResult, int iClientTxId) throws IOException {
        if (iResult == 0 || iResult == 3) {
            return iClientTxId;
        }
        if (iResult == 1) {
            ArrayList<OPair<String, String>> exceptions = new ArrayList<OPair<String, String>>();
            while (this.readByte() == 1) {
                String excClassName = this.readString();
                String excMessage = this.readString();
                exceptions.add(new OPair<String, String>(excClassName, excMessage));
            }
            byte[] serializedException = null;
            if (this.srvProtocolVersion >= 19) {
                serializedException = this.readBytes();
            }
            RuntimeException previous = null;
            if (serializedException != null && serializedException.length > 0) {
                this.throwSerializedException(serializedException);
            }
            for (int i = exceptions.size() - 1; i > -1; --i) {
                previous = OChannelBinaryClientAbstract.createException((String)((OPair)exceptions.get(i)).getKey(), (String)((OPair)exceptions.get(i)).getValue(), previous);
            }
            if (previous != null) {
                throw new RuntimeException(previous);
            }
            throw new ONetworkProtocolException("Network response error");
        }
        throw new ONetworkProtocolException("Error on reading response from the server");
    }

    protected void setReadResponseTimeout() throws SocketException {
        Socket s2 = this.socket;
        if (s2 != null && s2.isConnected() && !s2.isClosed()) {
            s2.setSoTimeout(this.socketTimeout);
        }
    }

    public void setWaitResponseTimeout() throws SocketException {
        Socket s2 = this.socket;
        if (s2 != null) {
            s2.setSoTimeout(OGlobalConfiguration.NETWORK_REQUEST_TIMEOUT.getValueAsInteger());
        }
    }

    protected void throwSerializedException(byte[] serializedException) throws IOException {
        OMemoryInputStream inputStream = new OMemoryInputStream(serializedException);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object throwable = null;
        try {
            throwable = objectInputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            OLogManager.instance().error(this, "Error during exception deserialization", e, new Object[0]);
            throw new IOException("Error during exception deserialization: " + e.toString(), e);
        }
        objectInputStream.close();
        if (throwable instanceof OException) {
            try {
                Class<?> cls = throwable.getClass();
                Constructor<?> constructor = cls.getConstructor(cls);
                OException proxyInstance = (OException)constructor.newInstance(throwable);
                throw proxyInstance;
            }
            catch (NoSuchMethodException e) {
                OLogManager.instance().error(this, "Error during exception deserialization", e, new Object[0]);
            }
            catch (InvocationTargetException e) {
                OLogManager.instance().error(this, "Error during exception deserialization", e, new Object[0]);
            }
            catch (InstantiationException e) {
                OLogManager.instance().error(this, "Error during exception deserialization", e, new Object[0]);
            }
            catch (IllegalAccessException e) {
                OLogManager.instance().error(this, "Error during exception deserialization", e, new Object[0]);
            }
        }
        if (throwable instanceof Throwable) {
            throw new OResponseProcessingException("Exception during response processing", (Throwable)throwable);
        }
        OLogManager.instance().error(this, "Error during exception serialization, serialized exception is not Throwable, exception type is " + (throwable != null ? throwable.getClass().getName() : "null"), null, new Object[0]);
    }
}

