/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool.importer;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.importer.OConverterData;
import com.orientechnologies.orient.core.db.tool.importer.OImportConvertersFactory;
import com.orientechnologies.orient.core.db.tool.importer.OValuesConverter;
import com.orientechnologies.orient.core.id.ORID;

public final class OLinkConverter
implements OValuesConverter<OIdentifiable> {
    private OConverterData converterData;

    public OLinkConverter(OConverterData importer) {
        this.converterData = importer;
    }

    @Override
    public OIdentifiable convert(OIdentifiable value) {
        ORID rid = value.getIdentity();
        if (!rid.isPersistent()) {
            return value;
        }
        if (this.converterData.brokenRids.contains(rid)) {
            return OImportConvertersFactory.BROKEN_LINK;
        }
        OIdentifiable newRid = this.converterData.exportImportHashTable.get(rid);
        if (newRid == null) {
            return value;
        }
        return newRid.getIdentity();
    }
}

