/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.hook;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;

public abstract class ODocumentHookAbstract
implements ORecordHook {
    private String[] includeClasses;
    private String[] excludeClasses;
    protected ODatabaseDocument database;

    @Deprecated
    public ODocumentHookAbstract() {
        this.database = ODatabaseRecordThreadLocal.instance().get();
    }

    public ODocumentHookAbstract(ODatabaseDocument database) {
        this.database = database;
    }

    @Override
    public void onUnregister() {
    }

    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public void onRecordAfterCreate(ODocument iDocument) {
    }

    public void onRecordCreateFailed(ODocument iDocument) {
    }

    public void onRecordCreateReplicated(ODocument iDocument) {
    }

    public ORecordHook.RESULT onRecordBeforeRead(ODocument iDocument) {
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public void onRecordAfterRead(ODocument iDocument) {
    }

    public void onRecordReadFailed(ODocument iDocument) {
    }

    public void onRecordReadReplicated(ODocument iDocument) {
    }

    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public void onRecordAfterUpdate(ODocument iDocument) {
    }

    public void onRecordUpdateFailed(ODocument iDocument) {
    }

    public void onRecordUpdateReplicated(ODocument iDocument) {
    }

    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public void onRecordAfterDelete(ODocument iDocument) {
    }

    public void onRecordDeleteFailed(ODocument iDocument) {
    }

    public void onRecordDeleteReplicated(ODocument iDocument) {
    }

    public void onRecordFinalizeUpdate(ODocument document) {
    }

    public void onRecordFinalizeCreation(ODocument document) {
    }

    public void onRecordFinalizeDeletion(ODocument document) {
    }

    @Override
    public ORecordHook.RESULT onTrigger(ORecordHook.TYPE iType, ORecord iRecord) {
        if (this.database.getStatus() != ODatabase.STATUS.OPEN) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        if (!(iRecord instanceof ODocument)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        ODocument document = (ODocument)iRecord;
        if (!this.filterBySchemaClass(document)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        switch (iType) {
            case BEFORE_CREATE: {
                return this.onRecordBeforeCreate(document);
            }
            case AFTER_CREATE: {
                this.onRecordAfterCreate(document);
                break;
            }
            case CREATE_FAILED: {
                this.onRecordCreateFailed(document);
                break;
            }
            case CREATE_REPLICATED: {
                this.onRecordCreateReplicated(document);
                break;
            }
            case BEFORE_READ: {
                return this.onRecordBeforeRead(document);
            }
            case AFTER_READ: {
                this.onRecordAfterRead(document);
                break;
            }
            case READ_FAILED: {
                this.onRecordReadFailed(document);
                break;
            }
            case READ_REPLICATED: {
                this.onRecordReadReplicated(document);
                break;
            }
            case BEFORE_UPDATE: {
                return this.onRecordBeforeUpdate(document);
            }
            case AFTER_UPDATE: {
                this.onRecordAfterUpdate(document);
                break;
            }
            case UPDATE_FAILED: {
                this.onRecordUpdateFailed(document);
                break;
            }
            case UPDATE_REPLICATED: {
                this.onRecordUpdateReplicated(document);
                break;
            }
            case BEFORE_DELETE: {
                return this.onRecordBeforeDelete(document);
            }
            case AFTER_DELETE: {
                this.onRecordAfterDelete(document);
                break;
            }
            case DELETE_FAILED: {
                this.onRecordDeleteFailed(document);
                break;
            }
            case DELETE_REPLICATED: {
                this.onRecordDeleteReplicated(document);
                break;
            }
            case FINALIZE_CREATION: {
                this.onRecordFinalizeCreation(document);
                break;
            }
            case FINALIZE_UPDATE: {
                this.onRecordFinalizeUpdate(document);
                break;
            }
            case FINALIZE_DELETION: {
                this.onRecordFinalizeDeletion(document);
                break;
            }
            default: {
                throw new IllegalStateException("Hook method " + (Object)((Object)iType) + " is not managed");
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public String[] getIncludeClasses() {
        return this.includeClasses;
    }

    public ODocumentHookAbstract setIncludeClasses(String ... includeClasses) {
        if (this.excludeClasses != null) {
            throw new IllegalStateException("Cannot include classes if exclude classes has been set");
        }
        this.includeClasses = includeClasses;
        return this;
    }

    public String[] getExcludeClasses() {
        return this.excludeClasses;
    }

    public ODocumentHookAbstract setExcludeClasses(String ... excludeClasses) {
        if (this.includeClasses != null) {
            throw new IllegalStateException("Cannot exclude classes if include classes has been set");
        }
        this.excludeClasses = excludeClasses;
        return this;
    }

    protected boolean filterBySchemaClass(ODocument iDocument) {
        if (this.includeClasses == null && this.excludeClasses == null) {
            return true;
        }
        OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(iDocument);
        if (clazz == null) {
            return false;
        }
        if (this.includeClasses != null) {
            for (String cls : this.includeClasses) {
                if (!clazz.isSubClassOf(cls)) continue;
                return true;
            }
            return false;
        }
        if (this.excludeClasses != null) {
            for (String cls : this.excludeClasses) {
                if (!clazz.isSubClassOf(cls)) continue;
                return false;
            }
        }
        return true;
    }
}

