/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.id;

import com.orientechnologies.common.util.OPatternConst;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ORecordId
implements ORID {
    public static final ORecordId EMPTY_RECORD_ID = new ORecordId();
    public static final byte[] EMPTY_RECORD_ID_STREAM = EMPTY_RECORD_ID.toStream();
    public static final int PERSISTENT_SIZE = 10;
    private static final long serialVersionUID = 247070594054408657L;
    private int clusterId = -1;
    private long clusterPosition = -1L;

    public ORecordId() {
    }

    public ORecordId(int iClusterId, long iPosition) {
        this.clusterId = iClusterId;
        this.checkClusterLimits();
        this.clusterPosition = iPosition;
    }

    public ORecordId(int iClusterIdId) {
        this.clusterId = iClusterIdId;
        this.checkClusterLimits();
    }

    public ORecordId(String iRecordId) {
        this.fromString(iRecordId);
    }

    public ORecordId(ORID parentRid) {
        this.clusterId = parentRid.getClusterId();
        this.clusterPosition = parentRid.getClusterPosition();
    }

    public static String generateString(int iClusterId, long iPosition) {
        StringBuilder buffer = new StringBuilder(12);
        buffer.append('#');
        buffer.append(iClusterId);
        buffer.append(':');
        buffer.append(iPosition);
        return buffer.toString();
    }

    public static boolean isValid(long pos) {
        return pos != -1L;
    }

    public static boolean isPersistent(long pos) {
        return pos > -1L;
    }

    public static boolean isNew(long pos) {
        return pos < 0L;
    }

    public static boolean isTemporary(long clusterPosition) {
        return clusterPosition < -1L;
    }

    public static boolean isA(String iString) {
        return OPatternConst.PATTERN_RID.matcher(iString).matches();
    }

    @Override
    public void reset() {
        this.clusterId = -1;
        this.clusterPosition = -1L;
    }

    @Override
    public boolean isValid() {
        return this.getClusterPosition() != -1L;
    }

    @Override
    public boolean isPersistent() {
        return this.getClusterId() > -1 && this.getClusterPosition() > -1L;
    }

    @Override
    public boolean isNew() {
        return this.getClusterPosition() < 0L;
    }

    @Override
    public boolean isTemporary() {
        return this.getClusterId() != -1 && this.getClusterPosition() < -1L;
    }

    public String toString() {
        return ORecordId.generateString(this.getClusterId(), this.getClusterPosition());
    }

    @Override
    public StringBuilder toString(StringBuilder iBuffer) {
        if (iBuffer == null) {
            iBuffer = new StringBuilder();
        }
        iBuffer.append('#');
        iBuffer.append(this.clusterId);
        iBuffer.append(':');
        iBuffer.append(this.getClusterPosition());
        return iBuffer;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OIdentifiable)) {
            return false;
        }
        ORecordId other = (ORecordId)((OIdentifiable)obj).getIdentity();
        if (this.getClusterId() != other.getClusterId()) {
            return false;
        }
        return this.getClusterPosition() == other.getClusterPosition();
    }

    public int hashCode() {
        return 31 * this.getClusterId() + 103 * (int)this.getClusterPosition();
    }

    @Override
    public int compareTo(OIdentifiable iOther) {
        if (iOther == this) {
            return 0;
        }
        if (iOther == null) {
            return 1;
        }
        int otherClusterId = iOther.getIdentity().getClusterId();
        if (this.getClusterId() == otherClusterId) {
            long otherClusterPos = iOther.getIdentity().getClusterPosition();
            return this.getClusterPosition() < otherClusterPos ? -1 : (this.getClusterPosition() == otherClusterPos ? 0 : 1);
        }
        if (this.getClusterId() > otherClusterId) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compare(OIdentifiable iObj1, OIdentifiable iObj2) {
        if (iObj1 == iObj2) {
            return 0;
        }
        if (iObj1 != null) {
            return iObj1.compareTo(iObj2);
        }
        return -1;
    }

    @Override
    public ORecordId copy() {
        return new ORecordId(this.getClusterId(), this.getClusterPosition());
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeShort(this.getClusterId());
        out.writeLong(this.getClusterPosition());
    }

    public void fromStream(DataInput in) throws IOException {
        this.setClusterId(in.readShort());
        this.setClusterPosition(in.readLong());
    }

    public ORecordId fromStream(InputStream iStream) throws IOException {
        this.setClusterId(OBinaryProtocol.bytes2short(iStream));
        this.setClusterPosition(OBinaryProtocol.bytes2long(iStream));
        return this;
    }

    public ORecordId fromStream(OMemoryStream iStream) {
        this.setClusterId(iStream.getAsShort());
        this.setClusterPosition(iStream.getAsLong());
        return this;
    }

    @Override
    public ORecordId fromStream(byte[] iBuffer) {
        if (iBuffer != null) {
            this.setClusterId(OBinaryProtocol.bytes2short(iBuffer, 0));
            this.setClusterPosition(OBinaryProtocol.bytes2long(iBuffer, 2));
        }
        return this;
    }

    @Override
    public int toStream(OutputStream iStream) throws IOException {
        int beginOffset = OBinaryProtocol.short2bytes((short)this.getClusterId(), iStream);
        OBinaryProtocol.long2bytes(this.getClusterPosition(), iStream);
        return beginOffset;
    }

    public int toStream(OMemoryStream iStream) throws IOException {
        int beginOffset = OBinaryProtocol.short2bytes((short)this.getClusterId(), iStream);
        OBinaryProtocol.long2bytes(this.getClusterPosition(), iStream);
        return beginOffset;
    }

    @Override
    public byte[] toStream() {
        byte[] buffer = new byte[10];
        OBinaryProtocol.short2bytes((short)this.getClusterId(), buffer, 0);
        OBinaryProtocol.long2bytes(this.getClusterPosition(), buffer, 2);
        return buffer;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public long getClusterPosition() {
        return this.clusterPosition;
    }

    public void fromString(String iRecordId) {
        if (iRecordId != null) {
            iRecordId = iRecordId.trim();
        }
        if (iRecordId == null || iRecordId.isEmpty()) {
            this.setClusterId(-1);
            this.setClusterPosition(-1L);
            return;
        }
        if (!OStringSerializerHelper.contains(iRecordId, ':')) {
            throw new IllegalArgumentException("Argument '" + iRecordId + "' is not a RecordId in form of string. Format must be: <cluster-id>:<cluster-position>");
        }
        List<String> parts = OStringSerializerHelper.split(iRecordId, ':', '#');
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Argument received '" + iRecordId + "' is not a RecordId in form of string. Format must be: #<cluster-id>:<cluster-position>. Example: #3:12");
        }
        this.setClusterId(Integer.parseInt(parts.get(0)));
        this.checkClusterLimits();
        this.setClusterPosition(Long.parseLong(parts.get(1)));
    }

    public void copyFrom(ORID iSource) {
        if (iSource == null) {
            throw new IllegalArgumentException("Source is null");
        }
        this.setClusterId(iSource.getClusterId());
        this.setClusterPosition(iSource.getClusterPosition());
    }

    @Override
    public void lock(boolean iExclusive) {
        ODatabaseRecordThreadLocal.instance().get().getTransaction().lockRecord(this, iExclusive ? OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK : OStorage.LOCKING_STRATEGY.SHARED_LOCK);
    }

    @Override
    public boolean isLocked() {
        return ODatabaseRecordThreadLocal.instance().get().getTransaction().isLockedRecord(this);
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return ODatabaseRecordThreadLocal.instance().get().getTransaction().lockingStrategy(this);
    }

    @Override
    public void unlock() {
        ODatabaseRecordThreadLocal.instance().get().getTransaction().unlockRecord(this);
    }

    @Override
    public String next() {
        return ORecordId.generateString(this.getClusterId(), this.getClusterPosition() + 1L);
    }

    @Override
    public ORID nextRid() {
        return new ORecordId(this.getClusterId(), this.getClusterPosition() + 1L);
    }

    @Override
    public ORID getIdentity() {
        return this;
    }

    @Override
    public <T extends ORecord> T getRecord() {
        if (!this.isValid()) {
            return null;
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (db == null) {
            throw new ODatabaseException("No database found in current thread local space. If you manually control databases over threads assure to set the current database before to use it by calling: ODatabaseRecordThreadLocal.instance().set(db);");
        }
        return (T)((ORecord)db.load(this));
    }

    private void checkClusterLimits() {
        if (this.getClusterId() < -2) {
            throw new ODatabaseException("RecordId cannot support negative cluster id. Found: " + this.getClusterId());
        }
        if (this.getClusterId() > Short.MAX_VALUE) {
            throw new ODatabaseException("RecordId cannot support cluster id major than 32767. Found: " + this.getClusterId());
        }
    }

    private void checkClusterLimits(int clusterId) {
        if (clusterId < -2) {
            throw new ODatabaseException("RecordId cannot support negative cluster id. Found: " + this.getClusterId());
        }
        if (clusterId > Short.MAX_VALUE) {
            throw new ODatabaseException("RecordId cannot support cluster id major than 32767. Found: " + this.getClusterId());
        }
    }

    public void setClusterId(int clusterId) {
        this.checkClusterLimits(clusterId);
        this.clusterId = clusterId;
    }

    public void setClusterPosition(long clusterPosition) {
        this.clusterPosition = clusterPosition;
    }
}

