/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class OIndexes {
    private static Set<OIndexFactory> FACTORIES = null;
    private static final Set<OIndexFactory> DYNAMIC_FACTORIES = Collections.synchronizedSet(new HashSet());
    private static ClassLoader orientClassLoader = OIndexes.class.getClassLoader();

    private OIndexes() {
    }

    private static synchronized Set<OIndexFactory> getFactories() {
        if (FACTORIES == null) {
            Iterator<OIndexFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OIndexFactory.class, orientClassLoader);
            HashSet<OIndexFactory> factories = new HashSet<OIndexFactory>();
            while (ite.hasNext()) {
                factories.add(ite.next());
            }
            factories.addAll(DYNAMIC_FACTORIES);
            FACTORIES = Collections.unmodifiableSet(factories);
        }
        return FACTORIES;
    }

    public static Iterator<OIndexFactory> getAllFactories() {
        return OIndexes.getFactories().iterator();
    }

    public static Set<String> getIndexTypes() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OIndexFactory> ite = OIndexes.getAllFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getTypes());
        }
        return types;
    }

    public static Set<String> getIndexEngines() {
        HashSet<String> engines = new HashSet<String>();
        Iterator<OIndexFactory> ite = OIndexes.getAllFactories();
        while (ite.hasNext()) {
            engines.addAll(ite.next().getAlgorithms());
        }
        return engines;
    }

    public static OIndexFactory getFactory(String indexType, String algorithm) {
        if (algorithm == null) {
            algorithm = OIndexes.chooseDefaultIndexAlgorithm(indexType);
        }
        Iterator<OIndexFactory> ite = OIndexes.getAllFactories();
        while (ite.hasNext()) {
            OIndexFactory factory = ite.next();
            if (!factory.getTypes().contains(indexType) || !factory.getAlgorithms().contains(algorithm)) continue;
            return factory;
        }
        throw new OIndexException("Index with type " + indexType + " and algorithm " + algorithm + " does not exist.");
    }

    public static OIndexInternal<?> createIndex(ODatabaseDocumentInternal database, String name, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException, OIndexException {
        if (indexType.equalsIgnoreCase(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.name()) || indexType.equalsIgnoreCase(OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.name()) || indexType.equalsIgnoreCase(OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.name())) {
            algorithm = "HASH_INDEX";
        }
        return OIndexes.findFactoryByAlgorithmAndType(algorithm, indexType).createIndex(name, database, indexType, algorithm, valueContainerAlgorithm, metadata, version);
    }

    public static OIndexFactory findFactoryByAlgorithmAndType(String algorithm, String indexType) {
        for (OIndexFactory factory : OIndexes.getFactories()) {
            if (indexType != null && !indexType.isEmpty() && (!factory.getTypes().contains(indexType) || !factory.getAlgorithms().contains(algorithm))) continue;
            return factory;
        }
        throw new OIndexException("Index type " + indexType + " is not supported by the engine '" + algorithm + "'. Types are " + OCollections.toString(OIndexes.getIndexTypes()));
    }

    public static OIndexEngine createIndexEngine(String name, String algorithm, String type, Boolean durableInNonTxMode, OStorage storage, int version, Map<String, String> indexProperties, ODocument metadata) {
        OIndexFactory factory = OIndexes.findFactoryByAlgorithmAndType(algorithm, type);
        return factory.createIndexEngine(algorithm, name, durableInNonTxMode, storage, version, indexProperties);
    }

    public static String chooseDefaultIndexAlgorithm(String type) {
        String algorithm = null;
        if (OClass.INDEX_TYPE.DICTIONARY.name().equals(type) || OClass.INDEX_TYPE.FULLTEXT.name().equals(type) || OClass.INDEX_TYPE.NOTUNIQUE.name().equals(type) || OClass.INDEX_TYPE.UNIQUE.name().equals(type)) {
            algorithm = "SBTREE";
        } else if (OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.name().equals(type) || OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.name().equals(type) || OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.name().equals(type) || OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.name().equals(type)) {
            algorithm = "HASH_INDEX";
        }
        return algorithm;
    }

    public static synchronized void scanForPlugins() {
        FACTORIES = null;
    }

    public static void registerFactory(OIndexFactory factory) {
        DYNAMIC_FACTORIES.add(factory);
        OIndexes.scanForPlugins();
    }

    public static void unregisterFactory(OIndexFactory factory) {
        DYNAMIC_FACTORIES.remove(factory);
        OIndexes.scanForPlugins();
    }
}

