/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializerAnyStreamable;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializerEmbedded;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;

public abstract class ORecordSerializerStringAbstract
implements ORecordSerializer,
Serializable {
    protected static final OProfiler PROFILER = Orient.instance().getProfiler();
    private static final char DECIMAL_SEPARATOR = '.';
    private static final String MAX_INTEGER_AS_STRING = String.valueOf(Integer.MAX_VALUE);
    private static final int MAX_INTEGER_DIGITS = MAX_INTEGER_AS_STRING.length();

    public static Object fieldTypeFromStream(ODocument iDocument, OType iType, Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iType == null) {
            iType = OType.EMBEDDED;
        }
        switch (iType) {
            case STRING: 
            case INTEGER: 
            case BOOLEAN: 
            case FLOAT: 
            case DECIMAL: 
            case LONG: 
            case DOUBLE: 
            case SHORT: 
            case BYTE: 
            case BINARY: 
            case DATE: 
            case DATETIME: 
            case LINK: {
                return ORecordSerializerStringAbstract.simpleValueFromStream(iValue, iType);
            }
            case EMBEDDED: {
                Object embeddedObject = OStringSerializerEmbedded.INSTANCE.fromStream((String)iValue);
                if (embeddedObject instanceof ODocument) {
                    ODocumentInternal.addOwner((ODocument)embeddedObject, iDocument);
                }
                return embeddedObject;
            }
            case CUSTOM: {
                Object result = OStringSerializerAnyStreamable.INSTANCE.fromStream((String)iValue);
                if (result instanceof ODocument) {
                    ODocumentInternal.addOwner((ODocument)result, iDocument);
                }
                return result;
            }
            case EMBEDDEDSET: 
            case EMBEDDEDLIST: {
                String value = (String)iValue;
                return ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionFromStream(iDocument, iType, null, null, value);
            }
            case EMBEDDEDMAP: {
                String value = (String)iValue;
                return ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedMapFromStream(iDocument, null, value, null);
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " not supported to convert value: " + iValue);
    }

    public static Object convertValue(String iValue, OType iExpectedType) {
        Object v = ORecordSerializerStringAbstract.getTypeValue(iValue);
        return OType.convert(v, iExpectedType.getDefaultJavaType());
    }

    public static void fieldTypeToString(StringBuilder iBuffer, OType iType, Object iValue) {
        if (iValue == null) {
            return;
        }
        long timer = PROFILER.startChrono();
        if (iType == null) {
            iType = iValue instanceof ORID ? OType.LINK : OType.EMBEDDED;
        }
        switch (iType) {
            case STRING: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.string2string"), "Serialize string to string", timer);
                break;
            }
            case BOOLEAN: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.bool2string"), "Serialize boolean to string", timer);
                break;
            }
            case INTEGER: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.int2string"), "Serialize integer to string", timer);
                break;
            }
            case FLOAT: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.float2string"), "Serialize float to string", timer);
                break;
            }
            case DECIMAL: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.decimal2string"), "Serialize decimal to string", timer);
                break;
            }
            case LONG: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.long2string"), "Serialize long to string", timer);
                break;
            }
            case DOUBLE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.double2string"), "Serialize double to string", timer);
                break;
            }
            case SHORT: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.short2string"), "Serialize short to string", timer);
                break;
            }
            case BYTE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.byte2string"), "Serialize byte to string", timer);
                break;
            }
            case BINARY: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.binary2string"), "Serialize binary to string", timer);
                break;
            }
            case DATE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.date2string"), "Serialize date to string", timer);
                break;
            }
            case DATETIME: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.datetime2string"), "Serialize datetime to string", timer);
                break;
            }
            case LINK: {
                if (iValue instanceof ORecordId) {
                    ((ORecordId)iValue).toString(iBuffer);
                } else {
                    ((OIdentifiable)iValue).getIdentity().toString(iBuffer);
                }
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.link2string"), "Serialize link to string", timer);
                break;
            }
            case EMBEDDEDSET: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionToStream(ODatabaseRecordThreadLocal.instance().getIfDefined(), null, iBuffer, null, null, iValue, true, true);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.embedSet2string"), "Serialize embeddedset to string", timer);
                break;
            }
            case EMBEDDEDLIST: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionToStream(ODatabaseRecordThreadLocal.instance().getIfDefined(), null, iBuffer, null, null, iValue, true, false);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.embedList2string"), "Serialize embeddedlist to string", timer);
                break;
            }
            case EMBEDDEDMAP: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedMapToStream(ODatabaseRecordThreadLocal.instance().getIfDefined(), null, iBuffer, null, null, iValue, true);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.embedMap2string"), "Serialize embeddedmap to string", timer);
                break;
            }
            case EMBEDDED: {
                if (iValue instanceof ODocument) {
                    ORecordSerializerSchemaAware2CSV.INSTANCE.toString((ODocument)iValue, iBuffer, null);
                } else {
                    OStringSerializerEmbedded.INSTANCE.toStream(iBuffer, iValue);
                }
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.embed2string"), "Serialize embedded to string", timer);
                break;
            }
            case CUSTOM: {
                OStringSerializerAnyStreamable.INSTANCE.toStream(iBuffer, iValue);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.custom2string"), "Serialize custom to string", timer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " not supported to convert value: " + iValue);
            }
        }
    }

    public static OType getType(String iValue) {
        if (iValue.length() == 0) {
            return null;
        }
        char firstChar = iValue.charAt(0);
        if (firstChar == '#') {
            return OType.LINK;
        }
        if (firstChar == '\'' || firstChar == '\"') {
            return OType.STRING;
        }
        if (firstChar == '_') {
            return OType.BINARY;
        }
        if (firstChar == '(') {
            return OType.EMBEDDED;
        }
        if (firstChar == '[') {
            return OType.EMBEDDEDLIST;
        }
        if (firstChar == '<') {
            return OType.EMBEDDEDSET;
        }
        if (firstChar == '{') {
            return OType.EMBEDDEDMAP;
        }
        if (firstChar == '^') {
            return OType.CUSTOM;
        }
        if (iValue.equalsIgnoreCase("true") || iValue.equalsIgnoreCase("false")) {
            return OType.BOOLEAN;
        }
        boolean integer = true;
        for (int index = 0; index < iValue.length(); ++index) {
            char c = iValue.charAt(index);
            if (c >= '0' && c <= '9' || index == 0 && (c == '+' || c == '-')) continue;
            if (c == '.') {
                integer = false;
                continue;
            }
            if (index > 0) {
                if (!integer && c == 'E') {
                    if (index < iValue.length()) {
                        if (iValue.charAt(index + 1) != '-') continue;
                        ++index;
                        continue;
                    }
                } else {
                    if (c == 'f') {
                        return index != iValue.length() - 1 ? OType.STRING : OType.FLOAT;
                    }
                    if (c == 'c') {
                        return index != iValue.length() - 1 ? OType.STRING : OType.DECIMAL;
                    }
                    if (c == 'l') {
                        return index != iValue.length() - 1 ? OType.STRING : OType.LONG;
                    }
                    if (c == 'd') {
                        return index != iValue.length() - 1 ? OType.STRING : OType.DOUBLE;
                    }
                    if (c == 'b') {
                        return index != iValue.length() - 1 ? OType.STRING : OType.BYTE;
                    }
                    if (c == 'a') {
                        return index != iValue.length() - 1 ? OType.STRING : OType.DATE;
                    }
                    if (c == 't') {
                        return index != iValue.length() - 1 ? OType.STRING : OType.DATETIME;
                    }
                    if (c == 's') {
                        return index != iValue.length() - 1 ? OType.STRING : OType.SHORT;
                    }
                    if (c == 'e') {
                        try {
                            Double.parseDouble(iValue);
                            return OType.DOUBLE;
                        }
                        catch (NumberFormatException ignore) {
                            return OType.STRING;
                        }
                    }
                }
            }
            return OType.STRING;
        }
        if (integer) {
            int numberLength = iValue.length();
            if (numberLength > MAX_INTEGER_DIGITS || numberLength == MAX_INTEGER_DIGITS && iValue.compareTo(MAX_INTEGER_AS_STRING) > 0) {
                return OType.LONG;
            }
            return OType.INTEGER;
        }
        double dou = Double.parseDouble(iValue);
        if (dou <= 3.4028234663852886E38 && dou >= (double)1.4E-45f && Double.toString(dou).equals(Float.toString((float)dou)) && new Double(new Double(dou).floatValue()) == dou) {
            return OType.FLOAT;
        }
        if (!new Double(dou).toString().equals(iValue)) {
            return OType.DECIMAL;
        }
        return OType.DOUBLE;
    }

    public static OType getType(String iValue, char iCharType) {
        if (iCharType == 'f') {
            return OType.FLOAT;
        }
        if (iCharType == 'c') {
            return OType.DECIMAL;
        }
        if (iCharType == 'l') {
            return OType.LONG;
        }
        if (iCharType == 'd') {
            return OType.DOUBLE;
        }
        if (iCharType == 'b') {
            if (iValue.length() >= 1 && iValue.length() <= 3) {
                return OType.BYTE;
            }
            return OType.BINARY;
        }
        if (iCharType == 'a') {
            return OType.DATE;
        }
        if (iCharType == 't') {
            return OType.DATETIME;
        }
        if (iCharType == 's') {
            return OType.SHORT;
        }
        if (iCharType == 'e') {
            return OType.EMBEDDEDSET;
        }
        if (iCharType == 'g') {
            return OType.LINKBAG;
        }
        if (iCharType == 'z') {
            return OType.LINKLIST;
        }
        if (iCharType == 'm') {
            return OType.LINKMAP;
        }
        if (iCharType == 'x') {
            return OType.LINK;
        }
        if (iCharType == 'n') {
            return OType.LINKSET;
        }
        if (iCharType == 'x') {
            return OType.LINK;
        }
        if (iCharType == 'u') {
            return OType.CUSTOM;
        }
        return OType.STRING;
    }

    public static Object getTypeValue(String iValue) {
        if (iValue == null || iValue.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (iValue.length() == 0) {
            return "";
        }
        if (iValue.length() > 1) {
            if (iValue.charAt(0) == '\"' && iValue.charAt(iValue.length() - 1) == '\"') {
                return OStringSerializerHelper.decode(iValue.substring(1, iValue.length() - 1));
            }
            if (iValue.charAt(0) == '_' && iValue.charAt(iValue.length() - 1) == '_') {
                return OStringSerializerHelper.getBinaryContent(iValue);
            }
            if (iValue.charAt(0) == '[' && iValue.charAt(iValue.length() - 1) == ']') {
                ArrayList<String> coll = new ArrayList<String>();
                OStringSerializerHelper.getCollection(iValue, 0, coll, '[', ']', ',');
                return coll;
            }
            if (iValue.charAt(0) == '<' && iValue.charAt(iValue.length() - 1) == '>') {
                HashSet<String> coll = new HashSet<String>();
                OStringSerializerHelper.getCollection(iValue, 0, coll, '<', '>', ',');
                return coll;
            }
            if (iValue.charAt(0) == '{' && iValue.charAt(iValue.length() - 1) == '}') {
                return OStringSerializerHelper.getMap(iValue);
            }
        }
        if (iValue.charAt(0) == '#') {
            return new ORecordId(iValue);
        }
        boolean integer = true;
        boolean stringStarBySign = false;
        for (int index = 0; index < iValue.length(); ++index) {
            char c = iValue.charAt(index);
            if (c < '0' || c > '9') {
                if (index == 0 && (c == '+' || c == '-')) {
                    stringStarBySign = true;
                    continue;
                }
                if (c == '.') {
                    integer = false;
                    continue;
                }
                if (index > 0) {
                    if (!integer && c == 'E') {
                        if (index < iValue.length()) {
                            ++index;
                        }
                        if (iValue.charAt(index) == '-') continue;
                    }
                    String v = iValue.substring(0, index);
                    if (c == 'f') {
                        return new Float(v);
                    }
                    if (c == 'c') {
                        return new BigDecimal(v);
                    }
                    if (c == 'l') {
                        return new Long(v);
                    }
                    if (c == 'd') {
                        return new Double(v);
                    }
                    if (c == 'b') {
                        return new Byte(v);
                    }
                    if (c == 'a' || c == 't') {
                        return new Date(Long.parseLong(v));
                    }
                    if (c == 's') {
                        return new Short(v);
                    }
                }
                return iValue;
            }
            if (!stringStarBySign) continue;
            stringStarBySign = false;
        }
        if (stringStarBySign) {
            return iValue;
        }
        if (integer) {
            try {
                return new Integer(iValue);
            }
            catch (NumberFormatException ignore) {
                return new Long(iValue);
            }
        }
        if ("NaN".equals(iValue) || "Infinity".equals(iValue)) {
            return new Double(iValue);
        }
        return new BigDecimal(iValue);
    }

    public static Object simpleValueFromStream(Object iValue, OType iType) {
        switch (iType) {
            case STRING: {
                if (iValue instanceof String) {
                    String s2 = OIOUtils.getStringContent(iValue);
                    return OStringSerializerHelper.decode(s2);
                }
                return iValue.toString();
            }
            case INTEGER: {
                if (iValue instanceof Integer) {
                    return iValue;
                }
                return new Integer(iValue.toString());
            }
            case BOOLEAN: {
                if (iValue instanceof Boolean) {
                    return iValue;
                }
                return new Boolean(iValue.toString());
            }
            case FLOAT: {
                if (iValue instanceof Float) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case DECIMAL: {
                if (iValue instanceof BigDecimal) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case LONG: {
                if (iValue instanceof Long) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case DOUBLE: {
                if (iValue instanceof Double) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case SHORT: {
                if (iValue instanceof Short) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case BYTE: {
                if (iValue instanceof Byte) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case BINARY: {
                return OStringSerializerHelper.getBinaryContent(iValue);
            }
            case DATE: 
            case DATETIME: {
                if (iValue instanceof Date) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case LINK: {
                if (iValue instanceof ORID) {
                    return iValue.toString();
                }
                if (iValue instanceof String) {
                    return new ORecordId((String)iValue);
                }
                return ((ORecord)iValue).getIdentity().toString();
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " is not simple type.");
    }

    public static void simpleValueToStream(StringBuilder iBuffer, OType iType, Object iValue) {
        if (iValue == null || iType == null) {
            return;
        }
        switch (iType) {
            case STRING: {
                iBuffer.append('\"');
                iBuffer.append(OStringSerializerHelper.encode(iValue.toString()));
                iBuffer.append('\"');
                break;
            }
            case BOOLEAN: {
                iBuffer.append(String.valueOf(iValue));
                break;
            }
            case INTEGER: {
                iBuffer.append(String.valueOf(iValue));
                break;
            }
            case FLOAT: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('f');
                break;
            }
            case DECIMAL: {
                if (iValue instanceof BigDecimal) {
                    iBuffer.append(((BigDecimal)iValue).toPlainString());
                } else {
                    iBuffer.append(String.valueOf(iValue));
                }
                iBuffer.append('c');
                break;
            }
            case LONG: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('l');
                break;
            }
            case DOUBLE: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('d');
                break;
            }
            case SHORT: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('s');
                break;
            }
            case BYTE: {
                if (iValue instanceof Character) {
                    iBuffer.append((int)((Character)iValue).charValue());
                } else if (iValue instanceof String) {
                    iBuffer.append(String.valueOf((int)((String)iValue).charAt(0)));
                } else {
                    iBuffer.append(String.valueOf(iValue));
                }
                iBuffer.append('b');
                break;
            }
            case BINARY: {
                iBuffer.append('_');
                if (iValue instanceof Byte) {
                    iBuffer.append(OBase64Utils.encodeBytes(new byte[]{(Byte)iValue}));
                } else {
                    iBuffer.append(OBase64Utils.encodeBytes((byte[])iValue));
                }
                iBuffer.append('_');
                break;
            }
            case DATE: {
                if (iValue instanceof Date) {
                    Calendar calendar = ODateHelper.getDatabaseCalendar();
                    calendar.setTime((Date)iValue);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    iBuffer.append(calendar.getTimeInMillis());
                } else {
                    iBuffer.append(iValue);
                }
                iBuffer.append('a');
                break;
            }
            case DATETIME: {
                if (iValue instanceof Date) {
                    iBuffer.append(((Date)iValue).getTime());
                } else {
                    iBuffer.append(iValue);
                }
                iBuffer.append('t');
            }
        }
    }

    public abstract ORecord fromString(String var1, ORecord var2, String[] var3);

    public StringBuilder toString(ORecord iRecord, StringBuilder iOutput, String iFormat) {
        return this.toString(iRecord, iOutput, iFormat, null, false, true);
    }

    public ORecord fromString(String iSource) {
        return this.fromString(iSource, (ORecord)ODatabaseRecordThreadLocal.instance().get().newInstance(), null);
    }

    @Override
    public String[] getFieldNames(ODocument reference, byte[] iSource) {
        return null;
    }

    @Override
    public ORecord fromStream(byte[] iSource, ORecord iRecord, String[] iFields) {
        long timer = PROFILER.startChrono();
        try {
            ORecord oRecord = this.fromString(new String(iSource, "UTF-8"), iRecord, iFields);
            return oRecord;
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSchemaException("Error reading record"), e);
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.fromStream"), "Deserialize record from stream", timer);
        }
    }

    @Override
    public byte[] toStream(ORecord iRecord, boolean iOnlyDelta) {
        long timer = PROFILER.startChrono();
        try {
            byte[] byArray = this.toString(iRecord, new StringBuilder(2048), null, null, iOnlyDelta, true).toString().getBytes("UTF-8");
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSchemaException("error encoding string"), e);
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.toStream"), "Serialize record to stream", timer);
        }
    }

    protected abstract StringBuilder toString(ORecord var1, StringBuilder var2, String var3, OUserObject2RecordHandler var4, boolean var5, boolean var6);

    @Override
    public boolean getSupportBinaryEvaluate() {
        return false;
    }
}

