/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OSQLFunctionList
extends OSQLFunctionMultiValueAbstract<List<Object>> {
    public static final String NAME = "list";

    public OSQLFunctionList() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams.length > 1) {
            this.context = new ArrayList();
        }
        for (Object value : iParams) {
            if (value == null) continue;
            if (iParams.length == 1 && this.context == null) {
                this.context = new ArrayList();
            }
            if (value instanceof Map) {
                ((List)this.context).add(value);
                continue;
            }
            OMultiValue.add(this.context, value);
        }
        return this.prepareResult((List)this.context);
    }

    @Override
    public String getSyntax() {
        return "list(<value>*)";
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    @Override
    public List<Object> getResult() {
        List res = (List)this.context;
        this.context = null;
        return this.prepareResult(res);
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        if (this.returnDistributedResult()) {
            HashSet result = new HashSet();
            for (Object iParameter : resultsToMerge) {
                Map container = (Map)((Collection)iParameter).iterator().next();
                result.addAll((Collection)container.get("context"));
            }
            return result;
        }
        if (!resultsToMerge.isEmpty()) {
            return resultsToMerge.get(0);
        }
        return null;
    }

    protected List<Object> prepareResult(List<Object> res) {
        if (this.returnDistributedResult()) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("node", this.getDistributedStorageId());
            doc.put("context", res);
            return Collections.singletonList(doc);
        }
        return res;
    }
}

