/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.List;

public class OSQLFunctionEval
extends OSQLFunctionMathAbstract {
    public static final String NAME = "eval";
    private OSQLPredicate predicate;

    public OSQLFunctionEval() {
        super(NAME, 1, 1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (this.predicate == null) {
            this.predicate = new OSQLPredicate(iParams[0].toString());
        }
        ODocument currentResult = iCurrentResult instanceof ODocument ? (ODocument)iCurrentResult : null;
        try {
            return this.predicate.evaluate(iRecord != null ? (OIdentifiable)iRecord.getRecord() : null, currentResult, iContext);
        }
        catch (ArithmeticException ignore) {
            return 0;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error in SQL function 'eval'", e, new Object[0]);
            return null;
        }
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public String getSyntax() {
        return "eval(<expression>)";
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        return null;
    }
}

