/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.Collection;
import java.util.List;

public class OSQLFunctionMin
extends OSQLFunctionMathAbstract {
    public static final String NAME = "min";
    private Object context;

    public OSQLFunctionMin() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Object min2 = null;
        for (Object item : iParams) {
            if (item instanceof Collection) {
                for (Object subitem : (Collection)item) {
                    if (min2 != null && (subitem == null || ((Comparable)subitem).compareTo(min2) >= 0)) continue;
                    min2 = subitem;
                }
                continue;
            }
            if (item instanceof Number && min2 instanceof Number) {
                Number[] converted = OType.castComparableNumber((Number)item, (Number)min2);
                item = converted[0];
                min2 = converted[1];
            }
            if (min2 != null && (item == null || ((Comparable)item).compareTo(min2) >= 0)) continue;
            min2 = item;
        }
        if (this.aggregateResults() && min2 != null) {
            if (this.context == null) {
                this.context = (Comparable)min2;
            } else {
                if (this.context instanceof Number && min2 instanceof Number) {
                    Number[] casted = OType.castComparableNumber((Number)this.context, (Number)min2);
                    this.context = casted[0];
                    min2 = casted[1];
                }
                if (((Comparable)this.context).compareTo((Comparable)min2) > 0) {
                    this.context = (Comparable)min2;
                }
            }
            return null;
        }
        return min2;
    }

    @Override
    public boolean aggregateResults() {
        return this.configuredParameters.length == 1 && !this.configuredParameters[0].toString().contains("$current");
    }

    @Override
    public String getSyntax() {
        return "min(<field> [,<field>*])";
    }

    @Override
    public Object getResult() {
        return this.context;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        Comparable context = null;
        for (Object iParameter : resultsToMerge) {
            Comparable value = (Comparable)iParameter;
            if (context == null) {
                context = value;
                continue;
            }
            if (context.compareTo(value) <= 0) continue;
            context = value;
        }
        return context;
    }
}

