/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchContext;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class OAsyncCommandResultListener
extends OAbstractCommandResultListener {
    private final ONetworkProtocolBinary protocol;
    private final AtomicBoolean empty = new AtomicBoolean(true);
    private final int txId;
    private final Set<ORID> alreadySent = new HashSet<ORID>();
    private final OClientConnection connection;

    public OAsyncCommandResultListener(OClientConnection connection, ONetworkProtocolBinary iNetworkProtocolBinary, int txId, OCommandResultListener wrappedResultListener) {
        super(wrappedResultListener);
        this.protocol = iNetworkProtocolBinary;
        this.txId = txId;
        this.connection = connection;
    }

    @Override
    public boolean result(Object iRecord) {
        if (this.empty.compareAndSet(true, false)) {
            try {
                this.protocol.sendOk(this.connection, this.txId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.fetchRecord(iRecord, new ORemoteFetchListener(){

                @Override
                protected void sendRecord(ORecord iLinked) {
                    if (!OAsyncCommandResultListener.this.alreadySent.contains(iLinked.getIdentity())) {
                        OAsyncCommandResultListener.this.alreadySent.add(iLinked.getIdentity());
                        try {
                            ((OAsyncCommandResultListener)OAsyncCommandResultListener.this).protocol.channel.writeByte((byte)2);
                            OAsyncCommandResultListener.this.protocol.writeIdentifiable(OAsyncCommandResultListener.this.connection, iLinked);
                        }
                        catch (IOException e) {
                            OLogManager.instance().error(this, "Cannot write against channel", e, new Object[0]);
                        }
                    }
                }
            });
            this.alreadySent.add(((OIdentifiable)iRecord).getIdentity());
            this.protocol.channel.writeByte((byte)1);
            this.protocol.writeIdentifiable(this.connection, (OIdentifiable)((OIdentifiable)iRecord).getRecord());
            this.protocol.channel.flush();
            if (this.wrappedResultListener != null) {
                this.wrappedResultListener.result(iRecord);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.empty.get();
    }

    @Override
    public void linkdedBySimpleValue(ODocument doc) {
        ORemoteFetchListener listener = new ORemoteFetchListener(){

            @Override
            protected void sendRecord(ORecord iLinked) {
                if (!OAsyncCommandResultListener.this.alreadySent.contains(iLinked.getIdentity())) {
                    OAsyncCommandResultListener.this.alreadySent.add(iLinked.getIdentity());
                    try {
                        ((OAsyncCommandResultListener)OAsyncCommandResultListener.this).protocol.channel.writeByte((byte)2);
                        OAsyncCommandResultListener.this.protocol.writeIdentifiable(OAsyncCommandResultListener.this.connection, iLinked);
                    }
                    catch (IOException e) {
                        OLogManager.instance().error(this, "Cannot write against channel", e, new Object[0]);
                    }
                }
            }

            @Override
            public void parseLinked(ODocument iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
                if (iLinked instanceof ORecord) {
                    this.sendRecord((ORecord)iLinked);
                }
            }

            @Override
            public void parseLinkedCollectionValue(ODocument iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
                if (iLinked instanceof ORecord) {
                    this.sendRecord((ORecord)iLinked);
                }
            }
        };
        ORemoteFetchContext context = new ORemoteFetchContext();
        OFetchHelper.fetch(doc, doc, OFetchHelper.buildFetchPlan(""), listener, context, "");
    }
}

