/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchContext;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import java.util.HashSet;
import java.util.Set;

public class OSyncCommandResultListener
extends OAbstractCommandResultListener {
    private final Set<ORecord> fetchedRecordsToSend = new HashSet<ORecord>();
    private final Set<ORecord> alreadySent = new HashSet<ORecord>();

    public OSyncCommandResultListener(OCommandResultListener wrappedResultListener) {
        super(wrappedResultListener);
    }

    @Override
    public boolean result(Object iRecord) {
        if (iRecord instanceof ORecord) {
            this.alreadySent.add((ORecord)iRecord);
            this.fetchedRecordsToSend.remove(iRecord);
        }
        if (this.wrappedResultListener != null) {
            this.wrappedResultListener.result(iRecord);
        }
        this.fetchRecord(iRecord, new ORemoteFetchListener(){

            @Override
            protected void sendRecord(ORecord iLinked) {
                if (!OSyncCommandResultListener.this.alreadySent.contains(iLinked)) {
                    OSyncCommandResultListener.this.fetchedRecordsToSend.add(iLinked);
                }
            }
        });
        return true;
    }

    public Set<ORecord> getFetchedRecordsToSend() {
        return this.fetchedRecordsToSend;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void linkdedBySimpleValue(ODocument doc) {
        ORemoteFetchListener listener = new ORemoteFetchListener(){

            @Override
            protected void sendRecord(ORecord iLinked) {
                if (!OSyncCommandResultListener.this.alreadySent.contains(iLinked)) {
                    OSyncCommandResultListener.this.fetchedRecordsToSend.add(iLinked);
                }
            }

            @Override
            public void parseLinked(ODocument iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
                if (!(iLinked instanceof ORecordId)) {
                    this.sendRecord((ORecord)iLinked.getRecord());
                }
            }

            @Override
            public void parseLinkedCollectionValue(ODocument iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
                if (!(iLinked instanceof ORecordId)) {
                    this.sendRecord((ORecord)iLinked.getRecord());
                }
            }
        };
        ORemoteFetchContext context = new ORemoteFetchContext();
        OFetchHelper.fetch(doc, doc, OFetchHelper.buildFetchPlan(""), listener, context, "");
    }
}

