/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandDeleteIndex
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"DELETE|index/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: index/<database>/<index-name>/<key>/[<value>]");
        iRequest.data.commandInfo = "Index remove";
        ODatabaseDocumentInternal db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            OIndex<?> index = db.getMetadata().getIndexManager().getIndex(urlParts[2]);
            if (index == null) {
                throw new IllegalArgumentException("Index name '" + urlParts[2] + "' not found");
            }
            boolean found = urlParts.length > 4 ? index.remove(urlParts[3], new ORecordId(urlParts[3])) : index.remove(urlParts[3]);
            if (found) {
                iResponse.send(200, "OK", "text/plain", null, null);
            } else {
                iResponse.send(404, "Not Found", "text/plain", null, null);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

