/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.put;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandPutDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"PUT|document/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: document/<database>[/<record-id>][?updateMode=full|partial]");
        iRequest.data.commandInfo = "Edit Document";
        ODatabaseDocumentInternal db = null;
        try {
            ORecordId recordId;
            db = this.getProfiledDatabaseInstance(iRequest);
            if (urlParts.length > 2) {
                int parametersPos = urlParts[2].indexOf(63);
                String rid = parametersPos > -1 ? urlParts[2].substring(0, parametersPos) : urlParts[2];
                recordId = new ORecordId(rid);
                if (!recordId.isValid()) {
                    throw new IllegalArgumentException("Invalid Record ID in request: " + recordId);
                }
            } else {
                recordId = new ORecordId();
            }
            ODocument doc = new ODocument();
            doc.fromJSON(iRequest.content).setTrackingChanges(false);
            if (iRequest.ifMatch != null) {
                ORecordInternal.setVersion(doc, Integer.parseInt(iRequest.ifMatch));
            }
            if (!recordId.isValid()) {
                recordId = (ORecordId)doc.getIdentity();
            }
            if (!recordId.isValid()) {
                throw new IllegalArgumentException("Invalid Record ID in request: " + recordId);
            }
            ODocument currentDocument = (ODocument)db.load(recordId);
            if (currentDocument == null) {
                iResponse.send(404, "Not Found", "text/plain", "Record " + recordId + " was not found.", null);
                boolean rid = false;
                return rid;
            }
            boolean partialUpdateMode = false;
            String mode = iRequest.getParameter("updateMode");
            if (mode != null && mode.equalsIgnoreCase("partial")) {
                partialUpdateMode = true;
            }
            if ((mode = iRequest.getHeader("updateMode")) != null && mode.equalsIgnoreCase("partial")) {
                partialUpdateMode = true;
            }
            currentDocument.merge(doc, partialUpdateMode, false);
            if (currentDocument.isDirty()) {
                if (doc.getVersion() > 0) {
                    ORecordInternal.setVersion(currentDocument, doc.getVersion());
                }
                currentDocument.save();
            }
            iResponse.send(200, "OK", "application/json", currentDocument.toJSON(), "ETag: " + currentDocument.getVersion());
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

