/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.plugin;

import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.plugin.OServerPlugin;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import java.util.Collection;

public class OServerPluginHelper {
    public static void invokeHandlerCallbackOnClientConnection(OServer iServer, OClientConnection connection) {
        Collection<OServerPluginInfo> plugins = iServer.getPlugins();
        if (plugins != null) {
            for (OServerPluginInfo plugin : plugins) {
                OServerPlugin pluginInstance = plugin.getInstance();
                if (pluginInstance == null) continue;
                plugin.getInstance().onClientConnection(connection);
            }
        }
    }

    public static void invokeHandlerCallbackOnClientDisconnection(OServer iServer, OClientConnection connection) {
        Collection<OServerPluginInfo> plugins = iServer.getPlugins();
        if (plugins != null) {
            for (OServerPluginInfo plugin : plugins) {
                OServerPlugin pluginInstance = plugin.getInstance();
                if (pluginInstance == null) continue;
                pluginInstance.onClientDisconnection(connection);
            }
        }
    }

    public static void invokeHandlerCallbackOnBeforeClientRequest(OServer iServer, OClientConnection connection, byte iRequestType) {
        Collection<OServerPluginInfo> plugins = iServer.getPlugins();
        if (plugins != null) {
            for (OServerPluginInfo plugin : plugins) {
                OServerPlugin pluginInstance = plugin.getInstance();
                if (pluginInstance == null) continue;
                pluginInstance.onBeforeClientRequest(connection, iRequestType);
            }
        }
    }

    public static void invokeHandlerCallbackOnAfterClientRequest(OServer iServer, OClientConnection connection, byte iRequestType) {
        Collection<OServerPluginInfo> plugins = iServer.getPlugins();
        if (plugins != null) {
            for (OServerPluginInfo plugin : plugins) {
                OServerPlugin pluginInstance = plugin.getInstance();
                if (pluginInstance == null) continue;
                pluginInstance.onAfterClientRequest(connection, iRequestType);
            }
        }
    }

    public static void invokeHandlerCallbackOnClientError(OServer iServer, OClientConnection connection, Throwable iThrowable) {
        Collection<OServerPluginInfo> plugins = iServer.getPlugins();
        if (plugins != null) {
            for (OServerPluginInfo plugin : plugins) {
                OServerPlugin pluginInstance = plugin.getInstance();
                if (pluginInstance == null) continue;
                pluginInstance.onClientError(connection, iThrowable);
            }
        }
    }
}

