/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionAbortedException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import com.orientechnologies.orient.server.tx.OTransactionEntryProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OTransactionOptimisticProxy
extends OTransactionOptimistic {
    private final Map<ORID, ORecordOperation> tempEntries = new LinkedHashMap<ORID, ORecordOperation>();
    private final Map<ORecordId, ORecord> createdRecords = new HashMap<ORecordId, ORecord>();
    private final Map<ORecordId, ORecord> updatedRecords = new HashMap<ORecordId, ORecord>();
    @Deprecated
    private final int clientTxId;
    private final OChannelBinary channel;
    private final short protocolVersion;
    private final ONetworkProtocolBinary oNetworkProtocolBinary;
    private final OClientConnection connection;

    public OTransactionOptimisticProxy(OClientConnection connection, ONetworkProtocolBinary protocolBinary) throws IOException {
        super((ODatabaseDocumentTx)connection.getDatabase());
        this.channel = protocolBinary.getChannel();
        this.clientTxId = this.channel.readInt();
        this.protocolVersion = connection.getData().protocolVersion;
        this.oNetworkProtocolBinary = protocolBinary;
        this.connection = connection;
    }

    @Override
    public void begin() {
        super.begin();
        ORecordNotFoundException toThrow = null;
        try {
            this.setUsingLog(this.channel.readByte() == 1);
            IdentityHashMap<ORecord, byte[]> lazyDeserialize = new IdentityHashMap<ORecord, byte[]>();
            byte lastTxStatus = this.channel.readByte();
            while (lastTxStatus == 1) {
                byte recordStatus = this.channel.readByte();
                ORecordId rid = this.channel.readRID();
                byte recordType = this.channel.readByte();
                OTransactionEntryProxy oTransactionEntryProxy = new OTransactionEntryProxy(recordType);
                oTransactionEntryProxy.type = recordStatus;
                switch (recordStatus) {
                    case 3: 
                    case 4: {
                        byte[] content = this.channel.readBytes();
                        ORecordInternal.fill(oTransactionEntryProxy.getRecord(), rid, 0, null, true);
                        lazyDeserialize.put(oTransactionEntryProxy.getRecord(), content);
                        if (recordStatus != 3) break;
                        this.createdRecords.put(rid.copy(), oTransactionEntryProxy.getRecord());
                        break;
                    }
                    case 1: {
                        int version = this.channel.readVersion();
                        byte[] bytes = this.channel.readBytes();
                        ORecordInternal.fill(oTransactionEntryProxy.getRecord(), rid, version, null, true);
                        lazyDeserialize.put(oTransactionEntryProxy.getRecord(), bytes);
                        if (this.protocolVersion < 23) break;
                        ORecordInternal.setContentChanged(oTransactionEntryProxy.getRecord(), this.channel.readBoolean());
                        break;
                    }
                    case 2: {
                        Object rec = rid.getRecord();
                        int deleteVersion = this.channel.readVersion();
                        if (rec == null) {
                            toThrow = new ORecordNotFoundException(rid);
                            break;
                        }
                        ORecordInternal.setVersion(rec, deleteVersion);
                        oTransactionEntryProxy.setRecord((OIdentifiable)rec);
                        break;
                    }
                    default: {
                        throw new OTransactionException("Unrecognized tx command: " + recordStatus);
                    }
                }
                this.tempEntries.put(oTransactionEntryProxy.getRecord().getIdentity(), oTransactionEntryProxy);
                lastTxStatus = this.channel.readByte();
            }
            String dbSerializerName = "";
            if (this.database != null) {
                dbSerializerName = this.database.getSerializer().toString();
            }
            String name = this.oNetworkProtocolBinary.getRecordSerializerName(this.connection);
            for (Map.Entry entry : lazyDeserialize.entrySet()) {
                ORecord record = (ORecord)entry.getKey();
                boolean contentChanged = ORecordInternal.isContentChanged(record);
                if (ORecordInternal.getRecordType(record) == 100 && !dbSerializerName.equals(name)) {
                    ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
                    ser.fromStream((byte[])entry.getValue(), record, null);
                    record.setDirty();
                    ORecordInternal.setContentChanged(record, contentChanged);
                    continue;
                }
                record.fromStream((byte[])entry.getValue());
                record.setDirty();
                ORecordInternal.setContentChanged(record, contentChanged);
            }
            if (toThrow != null) {
                throw toThrow;
            }
            if (lastTxStatus == -1) {
                throw new OTransactionAbortedException("Transaction aborted by the client");
            }
            ODocument remoteIndexEntries = new ODocument(this.channel.readBytes());
            this.fillIndexOperations(remoteIndexEntries);
            for (Map.Entry<ORID, ORecordOperation> entry : this.tempEntries.entrySet()) {
                if (entry.getValue().type == 1) {
                    Object record = entry.getValue().record.getRecord();
                    boolean contentChanged = ORecordInternal.isContentChanged(record);
                    Object loadedRecord = record.getIdentity().copy().getRecord();
                    if (loadedRecord == null) {
                        throw new ORecordNotFoundException(record.getIdentity());
                    }
                    if (ORecordInternal.getRecordType(loadedRecord) == 100 && ORecordInternal.getRecordType(loadedRecord) == ORecordInternal.getRecordType(record)) {
                        ((ODocument)loadedRecord).merge((ODocument)record, false, false);
                        loadedRecord.setDirty();
                        ORecordInternal.setContentChanged(loadedRecord, contentChanged);
                        ORecordInternal.setVersion(loadedRecord, record.getVersion());
                        entry.getValue().record = loadedRecord;
                        this.updatedRecords.put((ORecordId)entry.getKey(), entry.getValue().getRecord());
                    }
                }
                this.addRecord(entry.getValue().getRecord(), entry.getValue().type, null);
            }
            this.tempEntries.clear();
            for (ORecord record : this.createdRecords.values()) {
                this.unmarshallRecord(record);
                if (!(record instanceof ODocument)) continue;
                ODocumentInternal.autoConvertValueToClass(this.connection.getDatabase(), (ODocument)record);
            }
            for (ORecord record : this.updatedRecords.values()) {
                this.unmarshallRecord(record);
            }
        }
        catch (IOException e) {
            this.rollback();
            throw OException.wrapException(new OSerializationException("Cannot read transaction record from the network. Transaction aborted"), e);
        }
    }

    @Override
    public ORecord getRecord(ORID rid) {
        ORecord record = super.getRecord(rid);
        if (record == OTransactionRealAbstract.DELETED_RECORD) {
            return record;
        }
        if (record == null && rid.isNew()) {
            record = this.createdRecords.get(rid);
        }
        return record;
    }

    private void fillIndexOperations(ODocument remoteIndexEntries) {
        for (Map.Entry<String, Object> indexEntry : remoteIndexEntries) {
            Collection entries;
            Boolean clearAll;
            String indexName = indexEntry.getKey();
            ODocument indexDoc = (ODocument)indexEntry.getValue();
            if (indexDoc == null) continue;
            OTransactionIndexChanges transactionIndexChanges = (OTransactionIndexChanges)this.indexEntries.get(indexEntry.getKey());
            if (transactionIndexChanges == null) {
                transactionIndexChanges = new OTransactionIndexChanges();
                this.indexEntries.put(indexEntry.getKey(), transactionIndexChanges);
            }
            if ((clearAll = (Boolean)indexDoc.field("clear")) != null && clearAll.booleanValue()) {
                transactionIndexChanges.setCleared();
            }
            if ((entries = (Collection)indexDoc.field("entries")) == null) continue;
            for (ODocument entry : entries) {
                Object key;
                List operations = (List)entry.field("ops");
                if (operations == null) continue;
                try {
                    Object storedKey;
                    ODocument keyContainer;
                    if (this.protocolVersion <= 24) {
                        String serializedKey = OStringSerializerHelper.decode((String)entry.field("k"));
                        if (serializedKey.equals("*")) {
                            keyContainer = null;
                        } else {
                            keyContainer = new ODocument();
                            keyContainer.setLazyLoad(false);
                            ORecordSerializerSchemaAware2CSV.INSTANCE.fromString(serializedKey, keyContainer, null);
                        }
                    } else {
                        keyContainer = (ODocument)entry.field("k");
                    }
                    key = keyContainer != null ? ((storedKey = keyContainer.field("key")) instanceof List ? new OCompositeKey((List)storedKey) : (Boolean.TRUE.equals(keyContainer.field("binary")) ? OStreamSerializerAnyStreamable.INSTANCE.fromStream((byte[])storedKey) : storedKey)) : null;
                }
                catch (IOException ioe) {
                    throw OException.wrapException(new OTransactionException("Error during index changes deserialization. "), ioe);
                }
                for (ODocument op : operations) {
                    int operation = (Integer)op.rawField("o");
                    OTransactionIndexChanges.OPERATION indexOperation = OTransactionIndexChanges.OPERATION.values()[operation];
                    OIdentifiable value = (OIdentifiable)op.field("v");
                    transactionIndexChanges.getChangesPerKey(key).add(value, indexOperation);
                    if (value == null) continue;
                    ORID rid = value.getIdentity();
                    ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation> txIndexOperations = (ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation>)this.recordIndexOperations.get(rid);
                    if (txIndexOperations == null) {
                        txIndexOperations = new ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation>();
                        this.recordIndexOperations.put(rid, txIndexOperations);
                    }
                    txIndexOperations.add(new OTransactionRealAbstract.OTransactionRecordIndexOperation(indexName, key, indexOperation));
                }
            }
        }
    }

    public Map<ORecordId, ORecord> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORecordId, ORecord> getUpdatedRecords() {
        return this.updatedRecords;
    }

    private void unmarshallRecord(ORecord iRecord) {
        if (iRecord instanceof ODocument) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            for (Map.Entry<String, Object> field : (ODocument)iRecord) {
                Object value = field.getValue();
                if (!(value instanceof ORecordLazyList)) continue;
                ((ORecordLazyList)field.getValue()).lazyLoad(true);
            }
        }
    }
}

