/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

public class AttributedStyle {
    public static final int BLACK = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int YELLOW = 3;
    public static final int BLUE = 4;
    public static final int MAGENTA = 5;
    public static final int CYAN = 6;
    public static final int WHITE = 7;
    public static final int BRIGHT = 8;
    static final int F_BOLD = 1;
    static final int F_FAINT = 2;
    static final int F_ITALIC = 4;
    static final int F_UNDERLINE = 8;
    static final int F_BLINK = 16;
    static final int F_INVERSE = 32;
    static final int F_CONCEAL = 64;
    static final int F_CROSSED_OUT = 128;
    static final int F_FOREGROUND = 256;
    static final int F_BACKGROUND = 512;
    static final int F_HIDDEN = 1024;
    static final int MASK = 2047;
    static final int FG_COLOR_EXP = 16;
    static final int BG_COLOR_EXP = 24;
    static final int FG_COLOR = 0xFF0000;
    static final int BG_COLOR = -16777216;
    public static final AttributedStyle DEFAULT = new AttributedStyle();
    public static final AttributedStyle BOLD = DEFAULT.bold();
    public static final AttributedStyle BOLD_OFF = DEFAULT.boldOff();
    public static final AttributedStyle INVERSE = DEFAULT.inverse();
    public static final AttributedStyle INVERSE_OFF = DEFAULT.inverseOff();
    public static final AttributedStyle HIDDEN = DEFAULT.hidden();
    public static final AttributedStyle HIDDEN_OFF = DEFAULT.hiddenOff();
    final int style;
    final int mask;

    AttributedStyle() {
        this(0, 0);
    }

    AttributedStyle(int style, int mask) {
        this.style = style;
        this.mask = mask & 0x7FF | ((style & 0x100) != 0 ? 0xFF0000 : 0) | ((style & 0x200) != 0 ? -16777216 : 0);
    }

    public AttributedStyle bold() {
        return new AttributedStyle(this.style | 1, this.mask | 1);
    }

    public AttributedStyle boldOff() {
        return new AttributedStyle(this.style & 0xFFFFFFFE, this.mask | 1);
    }

    public AttributedStyle boldDefault() {
        return new AttributedStyle(this.style & 0xFFFFFFFE, this.mask & 0xFFFFFFFE);
    }

    public AttributedStyle faint() {
        return new AttributedStyle(this.style | 2, this.mask | 2);
    }

    public AttributedStyle faintOff() {
        return new AttributedStyle(this.style & 0xFFFFFFFD, this.mask | 2);
    }

    public AttributedStyle faintDefault() {
        return new AttributedStyle(this.style & 0xFFFFFFFD, this.mask & 0xFFFFFFFD);
    }

    public AttributedStyle italic() {
        return new AttributedStyle(this.style | 4, this.mask | 4);
    }

    public AttributedStyle italicOff() {
        return new AttributedStyle(this.style & 0xFFFFFFFB, this.mask | 4);
    }

    public AttributedStyle italicDefault() {
        return new AttributedStyle(this.style & 0xFFFFFFFB, this.mask & 0xFFFFFFFB);
    }

    public AttributedStyle underline() {
        return new AttributedStyle(this.style | 8, this.mask | 8);
    }

    public AttributedStyle underlineOff() {
        return new AttributedStyle(this.style & 0xFFFFFFF7, this.mask | 8);
    }

    public AttributedStyle underlineDefault() {
        return new AttributedStyle(this.style & 0xFFFFFFF7, this.mask & 0xFFFFFFF7);
    }

    public AttributedStyle blink() {
        return new AttributedStyle(this.style | 0x10, this.mask | 0x10);
    }

    public AttributedStyle blinkOff() {
        return new AttributedStyle(this.style & 0xFFFFFFEF, this.mask | 0x10);
    }

    public AttributedStyle blinkDefault() {
        return new AttributedStyle(this.style & 0xFFFFFFEF, this.mask & 0xFFFFFFEF);
    }

    public AttributedStyle inverse() {
        return new AttributedStyle(this.style | 0x20, this.mask | 0x20);
    }

    public AttributedStyle inverseNeg() {
        int s2 = (this.style & 0x20) != 0 ? this.style & 0xFFFFFFDF : this.style | 0x20;
        return new AttributedStyle(s2, this.mask | 0x20);
    }

    public AttributedStyle inverseOff() {
        return new AttributedStyle(this.style & 0xFFFFFFDF, this.mask | 0x20);
    }

    public AttributedStyle inverseDefault() {
        return new AttributedStyle(this.style & 0xFFFFFFDF, this.mask & 0xFFFFFFDF);
    }

    public AttributedStyle conceal() {
        return new AttributedStyle(this.style | 0x40, this.mask | 0x40);
    }

    public AttributedStyle concealOff() {
        return new AttributedStyle(this.style & 0xFFFFFFBF, this.mask | 0x40);
    }

    public AttributedStyle concealDefault() {
        return new AttributedStyle(this.style & 0xFFFFFFBF, this.mask & 0xFFFFFFBF);
    }

    public AttributedStyle crossedOut() {
        return new AttributedStyle(this.style | 0x80, this.mask | 0x80);
    }

    public AttributedStyle crossedOutOff() {
        return new AttributedStyle(this.style & 0xFFFFFF7F, this.mask | 0x80);
    }

    public AttributedStyle crossedOutDefault() {
        return new AttributedStyle(this.style & 0xFFFFFF7F, this.mask & 0xFFFFFF7F);
    }

    public AttributedStyle foreground(int color) {
        return new AttributedStyle(this.style & 0xFF00FFFF | 0x100 | color << 16 & 0xFF0000, this.mask | 0x100);
    }

    public AttributedStyle foregroundOff() {
        return new AttributedStyle(this.style & 0xFF00FFFF & 0xFFFFFEFF, this.mask | 0x100);
    }

    public AttributedStyle foregroundDefault() {
        return new AttributedStyle(this.style & 0xFF00FFFF & 0xFFFFFEFF, this.mask & 0xFF00FEFF);
    }

    public AttributedStyle background(int color) {
        return new AttributedStyle(this.style & 0xFFFFFF | 0x200 | color << 24 & 0xFF000000, this.mask | 0x200);
    }

    public AttributedStyle backgroundOff() {
        return new AttributedStyle(this.style & 0xFFFFFF & 0xFFFFFDFF, this.mask | 0x200);
    }

    public AttributedStyle backgroundDefault() {
        return new AttributedStyle(this.style & 0xFFFFFF & 0xFFFFFDFF, this.mask & 0xFFFDFF);
    }

    public AttributedStyle hidden() {
        return new AttributedStyle(this.style | 0x400, this.mask | 0x400);
    }

    public AttributedStyle hiddenOff() {
        return new AttributedStyle(this.style & 0xFFFFFBFF, this.mask | 0x400);
    }

    public AttributedStyle hiddenDefault() {
        return new AttributedStyle(this.style & 0xFFFFFBFF, this.mask & 0xFFFFFBFF);
    }

    int getStyle() {
        return this.style;
    }

    int getMask() {
        return this.mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributedStyle that = (AttributedStyle)o;
        if (this.style != that.style) {
            return false;
        }
        return this.mask == that.mask;
    }

    public int hashCode() {
        int result = this.style;
        result = 31 * result + this.mask;
        return result;
    }
}

